
function get_form_values()
{
	var formdata = new Array();
	var input_name;

	for (var i=0; i <= document.forms.iemainform.length-1; i++)
	{
		input_name = document.forms.iemainform[i].name;
		formdata[input_name] = document.forms.iemainform[i];
	}

	return formdata;
}

function set_default_form_values()
{
	var input_name;

	for (var i=0; i <= document.forms.iemainform.length-1; i++)
	{
		input_name = document.forms.iemainform[i].name;

		if (form_default_values_array[input_name] !== undefined)
		{
			document.forms.iemainform[i].value = form_default_values_array[input_name];
		}
		else if (input_name.search(/_force$/) != -1)
		{
			document.forms.iemainform[i].value = 0;
		}
	}
}

function input_error(name, error)
{
	alert("Error: Invalid input!\nForm field: " + name + "\n\n" + error);
	document.forms.iemainform[name].focus();
	document.forms.iemainform[name].select();
}

function update_graphic(sheet_id)
{
	if (sheet_id >= 0)
	{
		document.images["floor_graphic"].src = "./Item%20Graphics/G" + sheet_id + ".bmp";
		document.images["inv_graphic"].src = "./Item%20Graphics/G" + sheet_id + ".bmp";
		document.images["floor_icon"].src = "./Item%20Graphics/G" + sheet_id + ".bmp";
		document.images["inv_icon"].src = "./Item%20Graphics/G" + sheet_id + ".bmp";
	}
	else
	{
		document.images["floor_graphic"].src = "./Item%20Graphics/G1000.bmp";
		document.images["inv_graphic"].src = "./Item%20Graphics/G1000.bmp";
		document.images["floor_icon"].src = "./Item%20Graphics/G1000.bmp";
		document.images["inv_icon"].src = "./Item%20Graphics/G1000.bmp";

	}
}

function update_icon(which_icon)
{
	if (which_icon == 'floor' && document.forms.iemainform.custom_floor_graphic_number.value == '-1' && document.forms.iemainform.it_floor_which_sheet.value != '-1')
	{
		var input_value = document.forms.iemainform.it_floor_which_icon.value;
		var floor_icon = document.getElementById("floor_icon");
		switch (input_value)
		{
			case '0':
				floor_icon.style.clip='rect(0px, 30px, 30px, 0px)';
				floor_icon.style.marginLeft='0';
				break;
			case '1':
				floor_icon.style.clip='rect(0px, 59px, 30px, 29px)';
				floor_icon.style.marginLeft='-29';
				break;
			case '2':
				floor_icon.style.clip='rect(0px, 88px, 30px, 58px)';
				floor_icon.style.marginLeft='-58';
				break;
			case '3':
				floor_icon.style.clip='rect(0px, 117px, 30px, 87px)';
				floor_icon.style.marginLeft='-87';
				break;
			case '4':
				floor_icon.style.clip='rect(0px, 146px, 30px, 116px)';
				floor_icon.style.marginLeft='-116';
				break;
			case '5':
				floor_icon.style.clip='rect(0px, 175px, 30px, 145px)';
				floor_icon.style.marginLeft='-145';
				break;
			case '6':
				floor_icon.style.clip='rect(0px, 204px, 30px, 174px)';
				floor_icon.style.marginLeft='-174';
				break;
			case '7':
				floor_icon.style.clip='rect(0px, 233px, 30px, 203px)';
				floor_icon.style.marginLeft='-203';
				break;
			case '8':
				floor_icon.style.clip='rect(0px, 262px, 30px, 232px)';
				floor_icon.style.marginLeft='-232';
				break;
			case '9':
				floor_icon.style.clip='rect(0px, 291px, 30px, 261px)';
				floor_icon.style.marginLeft='-261';
				break;
		}
	}
	else if (which_icon == 'inv' && document.forms.iemainform.custom_floor_graphic_number.value == '-1' && document.forms.iemainform.it_floor_which_sheet.value != '-1')
	{
		var input_value = document.forms.iemainform.it_inventory_icon.value;
		var inv_icon = document.getElementById("inv_icon");
		switch (input_value)
		{
			case '0':
				inv_icon.style.clip='rect(0px, 30px, 30px, 0px)';
				inv_icon.style.marginLeft='0';
				break;
			case '1':
				inv_icon.style.clip='rect(0px, 59px, 30px, 29px)';
				inv_icon.style.marginLeft='-29';
				break;
			case '2':
				inv_icon.style.clip='rect(0px, 88px, 30px, 58px)';
				inv_icon.style.marginLeft='-58';
				break;
			case '3':
				inv_icon.style.clip='rect(0px, 117px, 30px, 87px)';
				inv_icon.style.marginLeft='-87';
				break;
			case '4':
				inv_icon.style.clip='rect(0px, 146px, 30px, 116px)';
				inv_icon.style.marginLeft='-116';
				break;
			case '5':
				inv_icon.style.clip='rect(0px, 175px, 30px, 145px)';
				inv_icon.style.marginLeft='-145';
				break;
			case '6':
				inv_icon.style.clip='rect(0px, 204px, 30px, 174px)';
				inv_icon.style.marginLeft='-174';
				break;
			case '7':
				inv_icon.style.clip='rect(0px, 233px, 30px, 203px)';
				inv_icon.style.marginLeft='-203';
				break;
			case '8':
				inv_icon.style.clip='rect(0px, 262px, 30px, 232px)';
				inv_icon.style.marginLeft='-232';
				break;
			case '9':
				inv_icon.style.clip='rect(0px, 291px, 30px, 261px)';
				inv_icon.style.marginLeft='-261';
				break;
		}
	}
	else
	{
		document.getElementById("floor_icon").style.clip='rect(0px, 30px, 30px, 0px)';
		document.getElementById("floor_icon").style.marginLeft='0';
		
		document.getElementById("inv_icon").style.clip='rect(0px, 30px, 30px, 0px)';
		document.getElementById("inv_icon").style.marginLeft='0';
	}
}


function Trim(s) // Trim function is by Brad Herder (www.vermontsoftware.com)
{
  // Remove leading spaces and carriage returns

  while ((s.substring(0,1) == ' ') || (s.substring(0,1) == '\n') || (s.substring(0,1) == '\r'))
  {
    s = s.substring(1,s.length);
  }

  // Remove trailing spaces and carriage returns

  while ((s.substring(s.length-1,s.length) == ' ') || (s.substring(s.length-1,s.length) == '\n') || (s.substring(s.length-1,s.length) == '\r'))
  {
    s = s.substring(0,s.length-1);
  }
  return s;
}


function generate_code()
{
	window.status = 'Generating...';
	var formdata = get_form_values();
	var it_code = '';
	//var numbers_only_regexp = new RegExp (/^\d+$/)
	
// Start checking input

// Item number
	if (formdata['it_number'].value == '')
	{
		input_error('it_number', 'You must enter item number!')
		return;
	}
	else if (isNaN(formdata['it_number'].value))
	{
		input_error('it_number', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += 'begindefineitem ' + formdata['it_number'].value + ";\n";
	}


// Clear
	if (formdata['clear'].value == '0')
	{
		// ok, no clear;
	}
	else
	{
		it_code += "\t" + 'clear' + ";\n";
	}


// Import
	if (formdata['import'].value == '' || formdata['import'].value == '-1')
	{
		// ok, no import
	}
	else if (isNaN(formdata['import'].value))
	{
		input_error('import', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + 'import = ' + formdata['import'].value + ";\n";
	}

// Name
	if (formdata['import'].value > 0 || formdata['it_name'].value == '')
	{
		if (formdata['import'].value == '-1' && formdata['it_full_name'].value == '')
		{
			input_error('it_name', 'You must give the item a name!');
			return;
		}
	}
	else
	{
		it_code += "\t" + "it_name = \"" + formdata['it_name'].value + "\";\n";
	}


// Full name
	if (formdata['it_full_name'].value == '')
	{
		if (formdata['import'].value == '-1' && formdata['it_name'].value == '')
		{
			input_error('it_full_name', 'You must give the item a name!');
			return;
		}
	}
	else
	{
		it_code += "\t" + "it_full_name = \"" + formdata['it_full_name'].value + "\";\n";
	}	
	
// Variety
	if (formdata['it_variety'].value == '0' && formdata['it_variety_force'].value != '1')
	{
		// ok, default variety
	}
	else
	{
		it_code += "\t" + "it_variety = " + formdata['it_variety'].value + "; // " + variety_array[formdata['it_variety'].value] + "\n";
	}


// Damage / lvl
	if ((formdata['it_damage_per_level'].value == '' || formdata['it_damage_per_level'].value == '0')  && formdata['it_damage_per_level_force'].value != '1')
	{
		// ok, default damage / lvl
	}
	else if (isNaN(formdata['it_damage_per_level'].value))
	{
		input_error('it_damage_per_level', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_damage_per_level = " + formdata['it_damage_per_level'].value + ";\n";
	}


// Bonus
	if ((formdata['it_bonus'].value == '' || formdata['it_bonus'].value == '0') && formdata['it_bonus_force'].value != '1')
	{
		// ok, no bonus
	}
	else if (isNaN(formdata['it_bonus'].value))
	{
		input_error('it_bonus', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_bonus = " + formdata['it_bonus'].value + ";\n";
	}


// Skill used
	if (formdata['it_weapon_skill_used'].value == '4' && formdata['it_weapon_skill_used_force'].value != '1')
	{
		// ok, default skill used
	}
	else
	{
		it_code += "\t" + "it_weapon_skill_used = " + formdata['it_weapon_skill_used'].value + "; // " + skills_array[formdata['it_weapon_skill_used'].value] + "\n";
	}


// Protection
	if ((formdata['it_protection'].value == '0') && formdata['it_protection_force'].value != '1')
	{
		// ok, no special ability
	}
	else if (isNaN(formdata['it_protection'].value))
	{
		input_error('it_protection', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_protection = " + formdata['it_protection'].value + ";\n";
	}


// Charges/amount
	if ((formdata['it_charges'].value == '0') && formdata['it_charges_force'].value != '1')
	{
		// ok, default charges/amount
	}
	else if (isNaN(formdata['it_charges'].value))
	{
		input_error('it_charges', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_charges = " + formdata['it_charges'].value + ";\n";
	}


// Encumbrance
	if ((formdata['it_encumbrance'].value == '0') && formdata['it_encumbrance_force'].value != '1')
	{
		// ok, default enbumbrance
	}
	else if (isNaN(formdata['it_encumbrance'].value))
	{
		input_error('it_encumbrance', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_encumbrance = " + formdata['it_encumbrance'].value + ";\n";
	}


// Graphic sheet
	if (formdata['import'].value != '-1' && formdata['custom_floor_graphic_number'].value == '-1' && formdata['it_floor_which_sheet'].value == '-1')
	{
		// sheet is imported
	}
	else if (formdata['custom_floor_graphic_number'].value != '-1')
	{
		it_code += "\t" + "it_floor_which_sheet = " + formdata['custom_floor_graphic_number'].value + ";\n";
	}
	else if (formdata['it_floor_which_sheet'].value != '-1')
	{
		it_code += "\t" + "it_floor_which_sheet = " + formdata['it_floor_which_sheet'].value + ";\n";
	}


// Floor icon
	if (1==2)
	{

	}
	else if (isNaN(formdata['it_floor_which_icon'].value))
	{
		input_error('it_floor_which_icon', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_floor_which_icon = " + formdata['it_floor_which_icon'].value + ";\n";
	}


// Inventory icon
	if (1==2)
	{

	}
	else if (isNaN(formdata['it_inventory_icon'].value))
	{
		input_error('it_inventory_icon', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_inventory_icon = " + formdata['it_inventory_icon'].value + ";\n";
	}


// Icon adjust
	if ((formdata['it_icon_adjust'].value == '0') && formdata['it_icon_adjust_force'].value != '1')
	{
		// ok, default icon adjust
	}
	else if (isNaN(formdata['it_icon_adjust'].value))
	{
		input_error('it_icon_adjust', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_icon_adjust = " + formdata['it_icon_adjust'].value + ";\n";
	}


// Special abilities
	for (var i=1; i <= 4; i++)
	{
		if (formdata['it_ability_' + i].value == '-1' && formdata['it_ability_str_' + i].value == '0')
		{
			// ok, default special ability
		}
		else
		{
			if (formdata['it_ability_' + i].value == '-1')
			{
				var comment = 'None';
			}
			else if (formdata['it_ability_' + i].value == '0')
			{
				var comment = 'Does nothing';
			}
			else
			{
				var comment = abilities_array[formdata['it_ability_' + i].value];
			}
			
			it_code += "\t" + "it_ability_" + i + " = " + formdata['it_ability_' + i].value + "; // " + comment + "\n";
			it_code += "\t" + "it_ability_str_" + i + " = " + formdata['it_ability_str_' + i].value + ";\n";
		}
	}


// Special class
	if ((formdata['it_special_class'].value == '' || formdata['it_special_class'].value == '0') && formdata['it_special_class_force'].value != '1')
	{
		// ok, default special class
	}
	else if (isNaN(formdata['it_special_class'].value))
	{
		input_error('it_special_class', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_special_class = " + formdata['it_special_class'].value + ";\n";
	}


// Value
	if ((formdata['it_value'].value == '' || formdata['it_value'].value == '0') && formdata['it_value_force'].value != '1')
	{
		// ok, default value
	}
	else if (isNaN(formdata['it_value'].value))
	{
		input_error('it_value', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_value = " + formdata['it_value'].value + ";\n";
	}


// Weight
	if ((formdata['it_weight'].value == '' || formdata['it_weight'].value == '0') && formdata['it_weight_force'].value != '1')
	{
		// ok, default weight
	}
	else if (isNaN(formdata['it_weight'].value))
	{
		input_error('it_weight', 'Numbers only, please.');
		return;
	}
	else
	{
		it_code += "\t" + "it_weight = " + formdata['it_weight'].value + ";\n";
	}

// Identified
	if ((formdata['it_identified'].value == '0') && formdata['it_identified_force'].value != '1')
	{
		// ok, default identified
	}
	else
	{
		it_code += "\t" + "it_identified = " + formdata['it_identified'].value + ";\n";
	}


// Magic
	if ((formdata['it_magic'].value == '0') && formdata['it_magic_force'].value != '1')
	{
		// ok, default magic
	}
	else
	{
		it_code += "\t" + "it_magic = " + formdata['it_magic'].value + ";\n";
	}


// Cursed
	if ((formdata['it_cursed'].value == '0') && formdata['it_cursed_force'].value != '1')
	{
		// ok, default cursed
	}
	else
	{
		it_code += "\t" + "it_cursed = " + formdata['it_cursed'].value + ";\n";
	}


// Once per day
	if ((formdata['it_once_per_day'].value == '0') && formdata['it_once_per_day_force'].value != '1')
	{
		// ok, use default
	}
	else
	{
		it_code += "\t" + "it_once_per_day = " + formdata['it_once_per_day'].value + ";\n";
	}


// Junk item
	if ((formdata['it_junk_item'].value == '0') && formdata['it_junk_item_force'].value != '1')
	{
		// ok, use default
	}
	else
	{
		it_code += "\t" + "it_junk_item = " + formdata['it_junk_item'].value + ";\n";
	}


// Missile animation
	if (formdata['it_missile_anim_type'].value == '-1')
	{
		// ok, use default
	}
	else
	{
		it_code += "\t" + "it_missile_anim_type = " + formdata['it_missile_anim_type'].value + ";\n";
	}

	document.forms.codeform.code.value = Trim(it_code);
}

function parse_code()
{
	window.status = 'Parsing...';
	var input_name;
	var input_value;
	
	set_default_form_values();

	var code = document.forms.codeform.code.value.replace(/\t/g, ''); // remove tabs

	if (code.search(/begindefineitem [0-9]+;/) == -1)
	{
		alert("Error!\n\n'begindefineitem' not found.")
		return;
	}

	code = code.replace(/\/\/(.*)/g, ''); // remove comments
	code = code.replace(/"/g, ""); // remove quotes
	code = Trim(code);
	var code_array = code.split(";");
	
	var code_firstline = code_array[0].split(" ");
	code_firstline[0] = Trim(code_firstline[0])
	code_firstline[1] = Trim(code_firstline[1])

	document.forms.iemainform['it_number'].value = code_firstline[1];

	code_array.shift(); // remove first line

	for (var i=0; i <= code_array.length-1; i++)
	{
		if (code_array[i].search(/=/) != -1)
		{
			code_array[i] = code_array[i].split('=');
			code_array[i][0] = Trim(code_array[i][0]);
			code_array[i][1] = Trim(code_array[i][1]);
			input_name = code_array[i][0].replace(/ /, '_'); // this is for array variables "cr_start_items 0" -> "cr_start_items_0"
			
			input_value = code_array[i][1];
			
			if (input_name == 'it_floor_which_sheet' && (input_value < 1000 || input_value > 1048))
			{
				input_name = 'custom_floor_graphic_number';
			}
			
			//alert("'" + input_name + "'");
			
			if(input_value == form_default_values_array[input_name] && (input_name != 'it_floor_which_icon' && input_name != 'it_inventory_icon' && input_name.search(/_str_/) == -1))
			{
				alert ("'" + input_name + "_force'");
				document.forms.iemainform[input_name + '_force'].value = '1';
			}

			document.forms.iemainform[input_name].value = input_value;
			//document.forms.iemainform[input_name].focus();
		}
		else if (Trim(code_array[i]) == 'clear')
		{
			document.forms.iemainform['clear'].value = 1;
		}
	}
	update_graphic(document.forms.iemainform.it_floor_which_sheet.value);
	update_icon('floor');
	update_icon('inv');
	
	if (document.forms.iemainform.it_missile_anim_type.value != '-1')
	{
		document.images.missile_anim.src='./Item%20Editor/img/missile_anim_' + document.forms.iemainform.it_missile_anim_type.value + '.png';
	}
	else
	{
		document.images.missile_anim.src='./Item%20Editor/img/missile_anim_0.png';
	}
}